/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.test;

import com.cisco.pt.impl.OptionsManager;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.CommandStatus;
import com.cisco.pt.ipc.sim.CiscoDevice;
import com.cisco.pt.ipc.sim.Network;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.ptmp.PacketTracerSessionFactory;
import com.cisco.pt.ptmp.impl.PacketTracerSessionFactoryImpl;
import com.cisco.pt.util.Pair;

public class Test1 {
    public static void main(String[] args) throws Exception {
        OptionsManager optionsManager = OptionsManager.getInstance(args[0]);
        PacketTracerSessionFactory sessionFactory = PacketTracerSessionFactoryImpl.getInstance();
        PacketTracerSession packetTracerSession = sessionFactory.openSession("localhost", 39000, null);
        if (packetTracerSession.isShutdown()) {
            System.out.println("Couldn't start Packet Tracer Session");
            return;
        }
        IPCFactory ipcFactory = new IPCFactory(packetTracerSession);
        Network network = ipcFactory.getIPC().network();
        CiscoDevice ciscoDevice = (CiscoDevice)network.getDeviceAt(0);
        Test1.enter(ciscoDevice, "en", "user");
        Test1.enter(ciscoDevice, "show run", "enable");
        Test1.enter(ciscoDevice, "host Bob", "global");
        packetTracerSession.close();
        System.exit(1);
    }

    protected static void enter(CiscoDevice ciscoDevice, String command, String mode) {
        Pair<CommandStatus, String> result = ciscoDevice.enterCommand(command, mode);
        System.out.println("\n(" + mode + ") " + command + " ==> ");
        System.out.println("\tfirst = " + (Object)((Object)result.getFirst()));
        System.out.println("\tsecond = " + result.getSecond());
    }
}

